% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualizeFitnessLandscape}
\alias{visualizeFitnessLandscape}
\title{Visualize Fitness Landscape}
\usage{
visualizeFitnessLandscape(
  fitness,
  selectNodes = NULL,
  nGenes = 4,
  lowColor = "white",
  highColor = "blue"
)
}
\arguments{
\item{fitness}{Fitness vectors for each genotype provided in selectNodes or for all genotypes if none selected}

\item{selectNodes}{Select genotypes to visualize}

\item{nGenes}{Length of each genotype}

\item{lowColor}{Color for wild type genotype}

\item{highColor}{Color for fully mutated genotype}
}
\value{
Plot (gg object) visualization of fitness landscape
}
\description{
Visualize Fitness Landscape
}
\examples{
genotypes <- c(
    "0000",
    "1000",
    "0100",
    "0010",
    "0001",
    "1100",
    "1010",
    "1001",
    "0110",
    "0101",
    "0011",
    "1110",
    "1101",
    "1011",
    "0111",
    "1111"
)
#
colIntensity <- c(0, rep(0.25, 4), rep(0.5, 6), rep(0.75, 4), 1)
visualizeFitnessLandscape(colIntensity)
}
