% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sce2fcs.R
\name{sce2fcs}
\alias{sce2fcs}
\title{SCE to \code{flowFrame/Set}}
\usage{
sce2fcs(x, split_by = NULL, keep_cd = FALSE, keep_dr = FALSE, assay = "counts")
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{split_by}{NULL or a character string 
specifying a \code{colData(x)} column to split by.}

\item{keep_cd, keep_dr}{logials specifying whether cell metadata 
(stored in \code{colData(x)}) and dimension reductions 
(stored in \code{reducedDims(x)}), respectively,
should be kept or dropped.}

\item{assay}{a character string specifying 
which assay data to use; valid values are \code{assayNames(x)}. 
When writing out FCS files, this should correspond to count-like data!}
}
\value{
a \code{\link[flowCore:flowFrame-class]{flowFrame}} 
if \code{split_by = NULL}; otherwise a 
\code{\link[flowCore:flowSet-class]{flowSet}}.
}
\description{
If \code{split_by = NULL}, the input SCE is converted to a 
\code{\link[flowCore:flowFrame-class]{flowFrame}}. Otherwise, 
it is split into a \code{\link[flowCore:flowSet-class]{flowSet}} 
by the specified \code{colData} column. 
Any cell metadata (\code{colData}) and dimension reductions 
available in the SCE may be dropped or propagated to the output.
}
\examples{
# PREPROCESSING
data(sample_ff, sample_key)
sce <- prepData(sample_ff, by_time = FALSE)
sce <- assignPrelim(sce, sample_key, verbose = FALSE)

# split SCE by barcode population
fs <- sce2fcs(sce, split_by = "bc_id")

# do some spot checks
library(flowCore)
library(SingleCellExperiment)

length(fs) == nrow(sample_key)
all(fsApply(fs, nrow)[, 1] == table(sce$bc_id))
identical(t(exprs(fs[[1]])), assay(sce, "exprs")[, sce$bc_id == "A1"])

# DIFFERENTIAL ANALYSIS
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce, verbose = FALSE)

# split by 20 metacluster populations
sce$meta20 <- cluster_ids(sce, "meta20")
fs <- sce2fcs(sce, split_by = "meta20", assay = "exprs")
all(fsApply(fs, nrow)[, 1] == table(sce$meta20))

}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
