% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normCytof.R
\name{normCytof}
\alias{normCytof}
\title{Bead-based normalization}
\usage{
normCytof(
  x,
  beads = c("dvs", "beta"),
  dna = c(191, 193),
  k = 500,
  trim = 5,
  remove_beads = TRUE,
  norm_to = NULL,
  assays = c("counts", "exprs"),
  overwrite = TRUE,
  transform = TRUE,
  cofactor = NULL,
  plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{beads}{\code{"dvs"} (for bead masses 140, 151, 153 ,165, 175) or 
\code{"beta"} (for bead masses 139, 141, 159, 169, 175) or 
a numeric vector of masses.}

\item{dna}{numeric vector of masses corresponding to DNA channels
(only one is required; output scatter plot (see Value section)  
will be generated using the first matching channel).}

\item{k}{integer width of the median window used 
for bead smoothing (affects visualizations only!).}

\item{trim}{a single non-negative numeric. 
A \emph{median}+/-\code{trim}*\emph{mad} rule is applied to 
preliminary bead populations to remove bead-bead doublets and 
low signal beads prior to estimating normalization factors.}

\item{remove_beads}{logical. If TRUE, bead events will be removed from
the input \code{SingleCellExperiment} and returned as a separate object?}

\item{norm_to}{a \code{\link[flowCore:flowFrame-class]{flowFrame}} or character string
specifying an FCS file from which to compute baseline bead intensities,
and to which the input data should be normalized to.}

\item{assays}{lnegth 2 character string specifying 
which assay data to use; both should be in \code{assayNames(x)} 
and correspond to count- and expression-like data, respectively.}

\item{overwrite}{logical; should the specified \code{assays}
(both, when \code{transform = TRUE}) be overwritten 
with the normalized data? If \code{FALSE}, normalized counts 
(and expressions, if \code{transform = TRUE}) will be stored in 
assay(s) \code{normcounts/exprs}, respectively.}

\item{transform}{logical; should normalized counts be 
arcsinh-transformed with the specified \code{cofactor}(s)?}

\item{cofactor}{numeric cofactor(s) to use for optional 
arcsinh-transformation when \code{transform = TRUE};
single value or a vector with channels as names.
If NULL, \code{normCytof} will try and access the cofactor(s)
stored in \code{int_metadata(x)}, thus re-using the same 
transformation applied previsouly.}

\item{plot}{logical; should bead vs. DNA scatters and smoothed bead 
intensities before vs. after normalization be included in the output?}

\item{verbose}{logical; should extra information on progress be reported?}
}
\value{
a list of the following \code{SingleCellExperiment}... 
\itemize{
\item{\code{data}: 
  The filtered input SCE (when \code{remove_beads = TRUE}); 
  otherwise, \code{colData} columns \code{is_bead} and \code{remove} 
  indicate whether an event as been identified as a bead or doublet.
  If \code{overwrite = FALSE}, assays \code{normcounts/exprs} are added;
  otherwise, the specified \code{counts/exprs} assays are overwritten.}
\item{\code{beads}, \code{removed}: 
  SCEs containing subsets of events identified as beads 
  and that were removed, respectively. The latter includes 
  bead-cell and cell-cell doublets)}
} ...and \code{ggplot} objects:
\itemize{
\item{\code{scatter}: scatter plot of DNA vs. bead
  intensities with indication of the applied gates}
\item{\code{lines}: running-median smoothed bead 
  intensities before and after normalization}
}
}
\description{
an implementation of Finck et al.'s normalization of mass cytometry data 
using bead standards with automated bead gating.
}
\examples{
data(raw_data)
sce <- prepData(raw_data)

# apply normalization & write normalized data to separate assays
res <- normCytof(sce, beads = "dvs", k = 80, overwrite = FALSE) 

ncol(res$beads)   # no. of bead events
ncol(res$removed) # no. of events removed

res$scatter # plot DNA vs. bead intensities including applied gates
res$lines   # plot smoothed bead intensities before vs. after normalization

# filtered SCE now additionally includes 
# normalized count & expression data
assayNames(res$data)

}
\references{
Finck, R. et al. (2013). 
Normalization of mass cytometry data with bead standards.
\emph{Cytometry A} \bold{83A}, 483-494.
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
