% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARD.imputation.R
\name{CARD_imputation}
\alias{CARD_imputation}
\title{Construct an enhanced spatial expression map on the unmeasured tissue
locations}
\usage{
CARD_imputation(CARD_object, num_grids, ineibor = 10, exclude = NULL)
}
\arguments{
\item{CARD_object}{SpatialExperiment Object created by
CARD_deconvolution with estimated cell type compositions on the
original spatial resolved transcriptomics data.}

\item{num_grids}{Initial number of newly grided spatial locations. The final
number of newly grided spatial locations will be lower than this value since
the newly grided locations outside the shape of the tissue will be filtered}

\item{ineibor}{Numeric, number of neighbors used in the imputation on newly
grided spatial locations, default is 10.}

\item{exclude}{Vector, the rownames of spatial location data on the original
resolution that you want to exclude. This is to avoid the weird detection of
the shape.}
}
\value{
Return a SpatialExperiment object with the refined cell type
compositions estimated for newly grided spots and the refined predicted
gene expression (normalized).
}
\description{
Construct an enhanced spatial expression map on the unmeasured tissue
locations
}
\examples{
data(spatial_count)
data(spatial_location)
data(sc_count)
data(sc_meta)
CARD_obj <- CARD_deconvolution(
    sc_count = sc_count,
    sc_meta = sc_meta,
    spatial_count = spatial_count,
    spatial_location = spatial_location,
    ct_varname = "cellType",
    ct_select = unique(sc_meta$cellType),
    sample_varname = "sampleInfo",
    mincountgene = 100,
    mincountspot = 5
)
CARD_obj <- CARD_imputation(
    CARD_obj,
    num_grids = 200,
    ineibor = 10,
    exclude = NULL
)

}
