% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCmethods.R
\name{summariseChrExpr}
\alias{summariseChrExpr}
\alias{summariseChrExpr,CAGEexp-method}
\title{Expression levels by chromosomes}
\usage{
summariseChrExpr(object)

\S4method{summariseChrExpr}{CAGEexp}(object)
}
\arguments{
\item{object}{A \code{CAGEexp} object objects are not supported).}
}
\value{
Modifies the \code{CAGEexp} by adding a \dQuote{seqNameTotals} experiment
containing matrices where rows represent chromosomes and columns represent samples.
}
\description{
Counts the number of molecules detected per chromosome, normalises
by library size and stores the raw and normalised results in the
\code{\link{CAGEr}} object.
}
\examples{
summariseChrExpr(exampleCAGEexp)

}
\seealso{
seqNameTotals

Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()}
}
\author{
Charles Plessy
}
\concept{CAGEr object modifiers}
