% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RleDataFrame.R
\name{rowSums.RleDataFrame}
\alias{rowSums.RleDataFrame}
\title{rowSums function for Rle DataFrames}
\usage{
rowSums.RleDataFrame(x, na.rm = FALSE)
}
\arguments{
\item{x}{A \code{DataFrame} containing only numerical \code{Rle} columns.}

\item{na.rm}{logical. Should missing values (including \code{NaN}) be omitted from
the calculations?}
}
\value{
A \code{Rle}-encoded numerical vector of the same class as in the
\code{DataFrame}.
}
\description{
Drop-in replacement for the \code{rowSums} function, which does not work natively
on \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}} objects containing \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle}}-encoded
numerical values.
}
\details{
See the file \code{benchmarks/rowSums_on_Rle_DF.md} in the source Git repository
of \emph{CAGEr} for the alternatives that were considered.
}
\examples{
exampleCAGEexp |> CTSStagCountDF() |> CAGEr:::rowSums.RleDataFrame(na.rm = TRUE)
}
\seealso{
Other Rle DataFrames: 
\code{\link{rowsum.RleDataFrame}()}
}
\author{
Charles Plessy
}
\concept{Rle DataFrames}
