% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\docType{methods}
\name{plotAnnot}
\alias{plotAnnot}
\alias{plotAnnot,data.frame-method}
\alias{plotAnnot,DataFrame-method}
\alias{plotAnnot,CAGEexp-method}
\alias{plotAnnot,GRangesList-method}
\title{Plot annotation statistics}
\usage{
plotAnnot(
  x,
  scope,
  title,
  group = "sampleLabels",
  facet = NULL,
  normalise = TRUE
)

\S4method{plotAnnot}{data.frame}(
  x,
  scope,
  title,
  group = "sampleLabels",
  facet = NULL,
  normalise = TRUE
)

\S4method{plotAnnot}{DataFrame}(
  x,
  scope,
  title,
  group = "sampleLabels",
  facet = NULL,
  normalise = TRUE
)

\S4method{plotAnnot}{CAGEexp}(
  x,
  scope,
  title,
  group = "sampleLabels",
  facet = NULL,
  normalise = TRUE
)

\S4method{plotAnnot}{GRangesList}(
  x,
  scope,
  title,
  group = "sampleLabels",
  facet = NULL,
  normalise = TRUE
)
}
\arguments{
\item{x}{An object from which can be extracted a table with columns named
\code{promoter}, \code{exon}, \code{intron}, \code{mapped}, \code{extracted}, \code{rdna}, and
\code{tagdust}, that will be passed to the \code{\link{mapStats}} function.}

\item{scope}{The name of a \emph{scope}, that defines which data is plotted
and how it is normalised, or a function implementing that scope.
See \code{\link{mapStatsScopes}} for details on each scope.}

\item{title}{The title of the plot.}

\item{group}{A factor to group the samples, or the name of a \code{colData}
column of a \code{CAGEexp} object, or a formula giving the names of columns
to be pasted together.  If no group is provided the sample labels will
be used.}

\item{facet}{A factor or the name of a \code{colData} column of a
\code{CAGEexp} object, to facet the samples in the sense of
\code{ggplot2}'s \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} function.}

\item{normalise}{Whether to normalise or not. Default: \code{TRUE}.}
}
\value{
Returns a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} object.
}
\description{
Extracts processing and alignment statistics from a \emph{CAGEr} object and plots
them as counts or percentages in stacked barplots.
}
\details{
When given a \code{\link{CAGEexp}} object or its \emph{column data}, what will be counted is
the number of \emph{CAGE tags}.  When given cluster objects (\code{\link{CTSS}},
\code{\link{TagClusters}} or \code{\link{ConsensusClusters}}) wrapped as
a \code{\link[GenomicRanges:GRangesList-class]{GenomicRanges::GRangesList}}, what will be counted is the number of
\emph{clusters}.

Stacked barplots with error bars inspired from
\url{http://stackoverflow.com/questions/10417003/stacked-barplot-with-errorbars-using-ggplot2}.
See \url{http://www.biomedcentral.com/1471-2164/14/665/figure/F1} for example.
}
\examples{
p <- plotAnnot(exampleCAGEexp, 'counts', 'Here is the title')
print(p)
p + ggplot2::theme_bw()
ggplot2::theme_set(ggplot2::theme_bw()) ; p
plotAnnot(exampleCAGEexp, 'counts', 'Same, non-normalised', normalise = FALSE)
exampleCAGEexp$myGroups <- factor(c("A", "A", "B", "B", "C"))
plotAnnot(exampleCAGEexp, 'counts', group = "myGroups")
plotAnnot(exampleCAGEexp, 'counts', group = ~myGroups)
plotAnnot(exampleCAGEexp, 'counts', group = ~sampleLabels + myGroups)
plotAnnot(exampleCAGEexp, CAGEr:::msScope_counts , group = "myGroups")

}
\seealso{
\code{\link{mapStats}} for a list of \emph{scopes}.

Other CAGEr annotation functions: 
\code{\link{annotateCTSS}()},
\code{\link{ranges2annot}()},
\code{\link{ranges2genes}()},
\code{\link{ranges2names}()}

Other CAGEr plot functions: 
\code{\link{TSSlogo}()},
\code{\link{hanabiPlot}()},
\code{\link{plotCorrelation}()},
\code{\link{plotExpressionProfiles}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{plotReverseCumulatives}()}
}
\author{
Charles Plessy
}
\concept{CAGEr annotation functions}
\concept{CAGEr plot functions}
