% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Paraclu.R
\name{paraclu}
\alias{paraclu}
\alias{paraclu,Pairs-method}
\alias{paraclu,CTSS-method}
\alias{paraclu,GRanges-method}
\alias{paraclu,SummarizedExperiment-method}
\alias{paraclu,CAGEexp-method}
\title{Parametric clustering}
\usage{
paraclu(
  object,
  minStability = 1,
  maxLength = 500,
  keepSingletonsAbove = 0,
  reduceToNonoverlapping = TRUE,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{paraclu}{Pairs}(
  object,
  minStability = 1,
  maxLength = 500,
  keepSingletonsAbove = 0,
  reduceToNonoverlapping = TRUE,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{paraclu}{CTSS}(
  object,
  minStability = 1,
  maxLength = 500,
  keepSingletonsAbove = 0,
  reduceToNonoverlapping = TRUE,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{paraclu}{GRanges}(
  object,
  minStability = 1,
  maxLength = 500,
  keepSingletonsAbove = 0,
  reduceToNonoverlapping = TRUE,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{paraclu}{SummarizedExperiment}(
  object,
  minStability = 1,
  maxLength = 500,
  keepSingletonsAbove = 0,
  reduceToNonoverlapping = TRUE,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{paraclu}{CAGEexp}(
  object,
  minStability = 1,
  maxLength = 500,
  keepSingletonsAbove = 0,
  reduceToNonoverlapping = TRUE,
  useMulticore = FALSE,
  nrCores = NULL
)
}
\arguments{
\item{object}{A \code{\link{CTSS}}, or a \code{\link[S4Vectors:Pairs-class]{S4Vectors::Pairs}} object with positions
\emph{first} and scores \emph{second}.}

\item{minStability}{Minimal stability of the cluster, where stability is
defined as ratio between maximal and minimal density value for which
this cluster is maximal scoring.  For definition of stability refer to
Frith \emph{et al.}, Genome Research, 2007.  Clusters with stability
\verb{< minStability} will be discarded.}

\item{maxLength}{Maximal length of cluster in base-pairs.  Clusters with length
\verb{> maxLength} will be discarded.}

\item{keepSingletonsAbove}{Remove "singleton" tag clusters of width 1 with
signal \verb{< keepSingletonsAbove}.  Default value \code{0} results in keeping
all TCs by default.  Setting it to \code{Inf} removes all singletons.}

\item{reduceToNonoverlapping}{Logical, should smaller clusters contained
within bigger cluster be removed to make a final set of tag clusters
non-overlapping.}

\item{useMulticore}{Logical, should multicore be used.  \code{useMulticore = TRUE}
has no effect on non-Unix-like platforms.}

\item{nrCores}{Number of cores to use when \code{useMulticore = TRUE}.  Default
value \code{NULL} uses all detected cores.}
}
\value{
Running Paraclu on a \code{Pairs} object containing positions and scores
returns an \code{IRanges} object containing the start and end positions of the
clusters, as well as the minimum and maximum density in \code{min_d} and \code{max_d}
metadata columns.

Running Paraclu on a \code{CTSS} object dispatches the computation on each strand
of each sequence level of the object, collects the \code{IRanges} and assemble
them back in a \code{\link{TagClusters}} object after filtering them by size and by
expression following the \code{minStability}, \code{maxLength}, \code{keepSingletonsAbove}
and \code{reduceToNonoverlapping} parameters.

Running Paraclu on a \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}} object will loop on each
sample, and return the results as a \code{\link[GenomicRanges:GRangesList-class]{GenomicRanges::GRangesList}} of \code{TagClusters}.

Running Paraclu on a \code{\link{CAGEexp}} returnts is with the clusters stored as a
\code{GRangesList} of \code{\link{TagClusters}} objects in its metadata slot \code{tagClusters}.
}
\description{
\code{"paraclu"} is an implementation of Paraclu algorithm for parametric
clustering of data attached to sequences (Frith \emph{et al.}, Genome Research,
2007).  Since Paraclu finds clusters within clusters (unlike \code{\link{distclu}}),
additional parameters (\code{minStability}, \code{maxLength} and \code{reduceToNonoverlapping})
can be specified to simplify the output by discarding too big clusters,
and to reduce the clusters to a final set of non-overlapping clusters.
}
\details{
Clustering is done for every CAGE dataset within the CAGEr object separately,
resulting in a different set of tag clusters for every CAGE dataset. TCs from
different datasets can further be aggregated into a single referent set of
consensus clusters by calling the \code{\link{aggregateTagClusters}} function.
}
\examples{
(ctss <- CTSSnormalizedTpmGR(exampleCAGEexp,1))
(pair <- Pairs(pos(ctss), score(ctss)))
CAGEr:::.paraclu_params(first(pair), second(pair))
CAGEr:::.paraclu(first(pair)[1:10], second(pair)[1:10])
paraclu(pair[1:10])
paraclu(ctss[1:10])
paraclu(CTSStagCountSE(exampleCAGEexp)[1:25,])
ce <- paraclu( exampleCAGEexp,
             , keepSingletonsAbove = 100
             , maxLength = 500, minStability = 1
             , reduceToNonoverlapping = TRUE)
tagClustersGR(ce, "Zf.30p.dome")

}
\references{
MC Frith, E Valen, A Krogh, Y Hayashizaki, P Carninci, A Sandelin.  \emph{A code
for transcription initiation in mammalian genomes.}  Genome Research 2008
18(1):1-12)
}
\seealso{
\code{\link{aggregateTagClusters}}

Other CAGEr clustering methods: 
\code{\link{consensusClustersTpm}()},
\code{\link{distclu}()}

Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{quantilePositions}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{consensusClustersDESeq2}()},
\code{\link{consensusClustersGR}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{quantilePositions}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr clustering methods}
\concept{CAGEr clusters functions}
\concept{CAGEr object modifiers}
