% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergingMethods.R
\name{mergeSamples}
\alias{mergeSamples}
\alias{mergeSamples,CAGEexp-method}
\title{Merge CAGE samples}
\usage{
mergeSamples(object, mergeIndex, mergedSampleLabels)

\S4method{mergeSamples}{CAGEexp}(object, mergeIndex, mergedSampleLabels)
}
\arguments{
\item{object}{A \code{\link{CAGEr}} object.}

\item{mergeIndex}{Integer vector specifying which experiments should be merged.
(one value per sample, see Details).}

\item{mergedSampleLabels}{Labels for the merged datasets (same length as the
number of unique values in \code{mergeIndex})}
}
\value{
The slots \code{sampleLabels}, \code{librarySizes} and \code{tagCountMatrix} of the
provided \code{\link{CAGEr}} object will be updated with the information on merged CAGE datasets
and will replace the previous information on individual CAGE datasets.  All further slots with
downstream information will be reset.
}
\description{
Merges individual CAGE samples (datasets, experiments) within
the CAGEr object into specified groups.
}
\details{
The samples within the CAGEr object are merged by adding the raw tag
counts of individual CTSS that belong tho the same group.  After merging, all
other slots in the CAGEr object will be reset and any previous data for
individual experiments will be removed.

\code{mergeIndex} controls which samples will be merged.  It is an integer
vector that assigns a group identifier to each sample, in the same order as
they are returned by \code{sampleLabels(object)}.  For example, if there are
8 CAGE samples in the CAGEr object and \code{mergeIndex = c(1,1,2,2,3,2,4,4)},
this will merge a) samples 1 and 2, b) samples 3, 4 and 6,  c) samples 7 and
8, and d) it will leave sample 5 as it is, resulting in 4 final merged datasets.

Labels provided in \code{mergedSampleLabels} will be assigned to merged datasets in the ascending
order of \code{mergeIndex} values, \emph{i.e.} first label will be assigned to a dataset created
by merging datasets labeled with lowest \code{mergeIndex} value (in this case \code{1}),
\emph{etc}.
}
\examples{

mergeSamples( exampleCAGEexp
            , mergeIndex = c(3,2,4,4,1)
            , mergedSampleLabels = c("zf_unfertilized", "zf_high", "zf_30p_dome", "zf_prim6"))
exampleCAGEexp

}
\author{
Vanja Haberle

Charles Plessy
}
