% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportMethods.R
\name{import.CTSS}
\alias{import.CTSS}
\title{import.CTSS}
\usage{
import.CTSS(filepath)
}
\arguments{
\item{filepath}{The path to the "CTSS" file.

Note that the format of the "CTSS" files handled in this function is not
the same as the FANTOM5 "CTSS" files (which are plain BED).}
}
\description{
Imports a "CTSS" file in a \link[GenomicRanges:GPos-class]{GenomicRanges::GPos} object
}
\examples{
CAGEr:::import.CTSS(system.file("extdata", "Zf.high.chr17.ctss", package = "CAGEr"))
}
\seealso{
Other loadFileIntoGPos: 
\code{\link{bam2CTSS}()},
\code{\link{import.bam}()},
\code{\link{import.bam.ctss}()},
\code{\link{import.bedCTSS}()},
\code{\link{import.bedScore}()},
\code{\link{import.bedmolecule}()},
\code{\link{import.bigwig}()},
\code{\link{loadFileIntoGPos}()},
\code{\link{moleculesGR2CTSS}()}
}
\concept{loadFileIntoGPos}
