% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R, R/SetMethods.R
\name{genomeName}
\alias{genomeName}
\alias{genomeName,CAGEexp-method}
\alias{genomeName,CTSS-method}
\alias{genomeName<-}
\alias{genomeName<-,CAGEexp-method}
\alias{genomeName<-,CTSS-method}
\title{Extracting genome name from CAGEr objects}
\usage{
genomeName(object)

\S4method{genomeName}{CAGEexp}(object)

\S4method{genomeName}{CTSS}(object)

genomeName(object) <- value

\S4method{genomeName}{CAGEexp}(object) <- value

\S4method{genomeName}{CTSS}(object) <- value
}
\arguments{
\item{object}{A CAGEexp or a CTSS object.}

\item{value}{The name of a \code{BSgenome} package.}
}
\value{
Returns a name of a BSgenome package used as a referent genome.
}
\description{
Extracts the name of a referent genome from a
\code{CAGEexp} or a \code{CTSS} object.
}
\details{
\code{\link{CAGEexp}} objects constructed with \code{NULL} in place
of the genome name can not run some commands that need access to genomic data,
such as BigWig export or G-correction.
}
\examples{
genomeName(exampleCAGEexp)

}
\seealso{
Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}

Other CAGEr setter methods: 
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{sampleLabels}()},
\code{\link{setColors}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr accessor methods}
\concept{CAGEr setter methods}
