% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusteringFunctions.R
\name{.ctss_summary_for_clusters}
\alias{.ctss_summary_for_clusters}
\title{Summarise CTSSs included in clusters}
\usage{
.ctss_summary_for_clusters(ctss, clusters)
}
\arguments{
\item{ctss}{A \code{\link{CTSS}} object.}

\item{clusters}{A \code{\link{TagClusters}}, \code{\link{ConsensusClusters}} or any other
object implementing the \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}} class.}
}
\value{
The \code{clusters} object with a new \code{dominant_CTSS} metadata in \code{CTSS}
format reporting the genomic coordinate and expression score of most
highly expressed position in each cluster, plus a \code{nr_ctss} metadata reporting
the number of expressed CTSSs in each cluster.
}
\description{
Summarise CTSSs included in clusters
}
\examples{
# See also benchmarks/dominant_ctss.md
(ctss <- CTSS( 'chr1', IRanges(start = 1:10, end = 1:10)
             , '+', score = c(1, 0, 0, 1, 2, 0, 2, 1, 0, 1)))
(clusters <- GRanges( 'chr1', IRanges(start = c(1,9)
                    , end = c(8,10)), '+')) |> as("TagClusters")

# The function assumes that all CTSSes have a score above zero
.ctss_summary_for_clusters(ctss[score(ctss)>0], clusters)
# If not the case, it will give incorrect nr_ctss and  fail to remove singletons
.ctss_summary_for_clusters(ctss, clusters)

# The function needs its output to be sorted and is not going to check it.
.ctss_summary_for_clusters(rev(ctss), clusters)
.ctss_summary_for_clusters(ctss, rev(clusters))

# Ties are resolved with 5' preference for both plus and minus strands.
# This may create a small bias.
ctss_minus <- ctss
strand(ctss_minus) <- '-'
clusters_minus <- clusters
strand(clusters_minus) <- '-'
.ctss_summary_for_clusters(ctss_minus, clusters_minus)
}
