% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R
\name{consensusClustersDESeq2}
\alias{consensusClustersDESeq2}
\alias{consensusClustersDESeq2,CAGEexp-method}
\title{Export \emph{consensus cluster} expression data for DESeq2 analysis}
\usage{
consensusClustersDESeq2(object, design)

\S4method{consensusClustersDESeq2}{CAGEexp}(object, design)
}
\arguments{
\item{object}{A CAGEexp object.}

\item{design}{A formula for the DESeq2 analysis.}
}
\description{
Creates a \code{DESeqDataSet} using the consensus cluster expression
data in the experiment slot \code{consensusClusters} and the sample metadata
of the \code{\link{CAGEexp}} object.  The formula must be built using factors
already present in the sample metadata.
}
\examples{
exampleCAGEexp$group <- c("a", "a", "b", "b", "a")
consensusClustersDESeq2(exampleCAGEexp, ~group)

}
\seealso{
\code{DESeqDataSet} in the \code{DESeq2} package.

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{consensusClustersGR}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{paraclu}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{quantilePositions}()},
\code{\link{tagClustersGR}()}
}
\author{
Charles Plessy
}
\concept{CAGEr clusters functions}
\concept{CAGEr expression analysis functions}
