% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantileWidthMethods.R
\name{.get.quant.pos}
\alias{.get.quant.pos}
\title{Get quantile positions}
\usage{
.get.quant.pos(cum.sums, clusters, q)
}
\arguments{
\item{cum.sums}{Named list of vectors containing cumulative sum for each
cluster (returned by the \code{CTSScumulativesTagClusters} or
\code{CTSScumulativesCC} function).}

\item{clusters}{\code{\link{TagClusters}} or \code{\link{ConsensusClusters}} object representing
tag clusters or consensus clusters.}

\item{q}{desired quantiles - single value or a vector of values.}
}
\value{
Returns the \code{clusters} object with one more metadata column per value
in \code{q}, containing \code{Rle} integers giving the relative distance of the
quantile boundaries to the start position.
}
\description{
Private function that calculates position of quantiles for CTSS clusters
based on distribution of tags within the clusters.
}
\examples{
cum.sums  <- RleList(`1` = Rle(1), `2` = cumsum(Rle(c(1, 1, 1, 2, 4, 0, 1, 1))))
clusters <- GRanges(c("chr1:100-101", "chr1:120-127"))
CAGEr:::.get.quant.pos(cum.sums, clusters, c(.2, .8))
}
