% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R, R/SetMethods.R
\name{CTSScoordinatesGR}
\alias{CTSScoordinatesGR}
\alias{CTSScoordinatesGR,CAGEexp-method}
\alias{CTSScoordinatesGR<-}
\alias{CTSScoordinatesGR<-,CAGEexp-method}
\alias{CTSStagCountSE<-}
\alias{CTSStagCountSE<-,CAGEexp-method}
\title{Genomic coordinates of TSSs from a \code{CAGEr} object}
\usage{
CTSScoordinatesGR(object)

\S4method{CTSScoordinatesGR}{CAGEexp}(object)

CTSScoordinatesGR(object) <- value

\S4method{CTSScoordinatesGR}{CAGEexp}(object) <- value

CTSStagCountSE(object) <- value

\S4method{CTSStagCountSE}{CAGEexp}(object) <- value
}
\arguments{
\item{object}{A \code{CAGEexp} object.}

\item{value}{Coordinates to update, in a format according to the function name.}
}
\value{
\code{CTSScoordinatesGR} returns the coordinates as a \code{\link[=CTSS]{CTSS()}} object
wrapping genomic ranges.  A \code{filteredCTSSidx} column metadata will be present
if \code{\link{filterLowExpCTSS}} was ran earlier.
}
\description{
Extracts the genomic coordinates of all detected TSSs
from \link{CAGEexp} objects.
}
\examples{
CTSScoordinatesGR(exampleCAGEexp)

CTSScoordinatesGR(exampleCAGEexp)

}
\seealso{
\code{\link{getCTSS}}

Other CAGEr accessor methods: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr accessor methods}
