% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAGEr-package.R
\docType{package}
\name{CAGEr-package}
\alias{CAGEr}
\alias{CAGEr-package}
\title{CAGEr: Analysis of CAGE (Cap Analysis of Gene Expression) sequencing data for precise mapping of transcription start sites and promoterome mining}
\description{
The _CAGEr_ package identifies transcription start sites (TSS) and their usage frequency from CAGE (Cap Analysis Gene Expression) sequencing data. It normalises raw CAGE tag count, clusters TSSs into tag clusters (TC) and aggregates them across multiple CAGE experiments to construct consensus clusters (CC) representing the promoterome. CAGEr provides functions to profile expression levels of these clusters by cumulative expression and rarefaction analysis, and outputs the plots in ggplot2 format for further facetting and customisation. After clustering, CAGEr performs analyses of promoter width and detects differential usage of TSSs (promoter shifting) between samples. CAGEr also exports its data as genome browser tracks, and as R objects for downsteam expression analysis by other Bioconductor packages such as DESeq2, CAGEfightR, or seqArchR.
}
\author{
\strong{Maintainer}: Charles Plessy \email{charles.plessy@oist.jp}

Authors:
\itemize{
  \item Vanja Haberle \email{vanja.haberle@gmail.com}
}

Other contributors:
\itemize{
  \item Damir Baranasic \email{damir.baranasic@lms.mrc.ac.uk} [contributor]
  \item Katalin Ferenc \email{k.t.ferenc@ncmbm.uio.no} [contributor]
  \item Sarvesh Nikumbh \email{s.nikumbh@lms.mrc.ac.uk} [contributor]
}

}
\keyword{internal}
