% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrowserViz-class.R
\docType{package}
\name{BrowserViz-class}
\alias{BrowserViz-class}
\alias{.BrowserViz}
\title{BrowserViz:  a base class providing simple, extensible message passing between
your R session and your web browser, for interactive data visualization.}
\description{
Many of the best interactive graphics capabilities available today are written in Javascript and
run in a web browser.  BrowserViz makes these capabilities available in R, using websockets
for message passing back and forth between R and the browser. This class connects your R session to your web browser via websockets,
using the R httupv library, which in turn uses the Rook webserver.

BrowserViz is a concrete base class, in that instances can be constructed and run - which we do for testing.
The primary use of this BrowserViz is to be subclassed: to facilitate the creation of new
browser-based, R-connected interactive graphics capabilities embodied in R packages, written by
programmers with some skill in both R and Javascript.  Two examples of this can
be found in these Bioconductor packages \url{https://bioconductor.org/packages/devel/bioc/html/igvR.html}
and \url{https://bioconductor.org/packages/devel/bioc/html/RCyjs.html}.
}
\section{Slots}{

\describe{
\item{\code{uri}}{The http location at which this modest webserver runs}

\item{\code{port}}{An integer port number for the http connection}

\item{\code{websocketConnection}}{An environment managed by the httpuv library on our behalf}

\item{\code{quiet}}{Logical varaible controlling verbosity during execution}
}}

\seealso{
\code{\link{BrowserViz}}

An S4 class to create and manage a modest webserver for websocket message passing  between R and Javascript
running in your web browser
}
