% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fold_change.R
\name{fold_change}
\alias{fold_change}
\title{calculation of Fold-Change}
\usage{
fold_change(
  df_raw = df_raw,
  sample_info = sample_info,
  Group_column = Group_column,
  Test_group = Test_group,
  Ref_group = Ref_group
)
}
\arguments{
\item{df_raw}{Matrix of normalized expression data (not Log2 transformed).
Genes should be in rows and Sample ID in columns. Row names are required to be valid Gene Symbols}

\item{sample_info}{A dataframe with sample annotation. Sample_info dataframe requires two columns: 1) a column specifying Sample ID (exactly matching Sample ID of data.matrix) and 2) a column specifying group names}

\item{Group_column}{Character vector identical to the column name from sample_info dataframe that specifies group annotation used for the analysis}

\item{Test_group}{Character vector specifying values within the group column (Group_column) that will be used as Test group (samples considered as cases or “intervention” group).}

\item{Ref_group}{Character vector specifying value within the group column (Group_column) that will be used as Reference group}
}
\value{
A matrix of the fold change comparison between "Test_group" vs ""Ref_group"
}
\description{
A function to calculate fold-change between group comparison; "Test_group" vs "Ref_group"
}
\examples{
## data could be downloaded from ExperimentHub("GSE13015")
library(ExperimentHub)
library(SummarizedExperiment)
dat = ExperimentHub()
res = query(dat , "GSE13015")
GSE13015 = res[["EH5429"]]
data_matrix = assay(GSE13015)
sample_ann = data.frame(colData(GSE13015))

FCgroup = fold_change(df_raw = data_matrix[c(1:5),],
                     sample_info = sample_ann,
                     Group_column = "Group_test",
                     Test_group="Sepsis",
                     Ref_group="Control")

}
\author{
Darawan Rinchai \href{mailto:drinchai@gmail.com}{drinchai@gmail.com}
}
