% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{plotIc}
\alias{plotIc}
\title{plot a line plot of Ic scores for each state.}
\usage{
plotIc(
  Ic,
  las = 0,
  order = NULL,
  ylab = "Ic",
  col = "black",
  main = NULL,
  add = FALSE,
  ylim = NULL,
  lty = 1:5,
  lwd = 1
)
}
\arguments{
\item{Ic}{A vector with names of states. If order is not assigned,
then plot by the order of this vector.}

\item{las}{Numeric in {0, 1, 2, 3}; the style of axis labels.
Default is 0,  meaning labels are parallel.
(link to http://127.0.0.1:21580/library/graphics/html/par.html).}

\item{order}{A vector of state names in the customized order to be plotted, setting to NULL by default.}

\item{ylab}{titles y axes, as in plot.}

\item{col}{vector of colors. Colors are used cyclically.}

\item{main}{A character vector. The title of the plot. Default is NULL.}

\item{add}{logical. If TRUE,  plots are added to current one.
This is inherited from \link[graphics]{matplot}.}

\item{ylim}{An integer vector of length 2. Default is NULL.}

\item{lty}{An vector of line types. This is also inherited from \link[graphics]{matplot}.}

\item{lwd}{Anineger of line widths. This is also inherited from \link[graphics]{matplot}.}
}
\value{
Return a line plot of Ic score across states.
}
\description{
plot a line plot with Ic score for each state
}
\examples{
Ic = c('state3' = 3.4,  'state1' = 5.6,  'state2' = 2)
plotIc(Ic, order = c('state1', 'state2', 'state3'))
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}
}
