% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getMaxStats}
\alias{getMaxStats}
\title{Get the cluster index and network nodes of biomodule}
\usage{
getMaxStats(membersL, idx)
}
\arguments{
\item{membersL}{A two-layer nested list of character or numeric values,
any one out of the five elements output by the function \code{\link{getMCI}}.}

\item{idx}{A vector of integers that are cluster ids of the biomodule
(the module with the highest MCI score) per state.
This is the first element of the result from \code{\link{getMaxMCImember}}.}
}
\value{
A list describing the biomodule of each state,  corresponding to one of the five elements
(members,  MCI,  Sd,  PCC,  and PCCo) outputted by the function \code{\link{getMCI}}.
The calss of the vector depends on the class of the input parameter \code{membersL}.
}
\description{
This function retrieves the cluster index and network-node ids
for the identified biomodule (that shows the maximum MCI score) at each state in the study.
}
\examples{
test = list('state1' = matrix(sample(1:10, 6), 4, 3), 
   'state2' = matrix(sample(1:10, 6), 4, 3), 
   'state3' = matrix(sample(1:10, 6), 4, 3))
   
# assign colnames and rownames to the matrix
for(i in names(test)){
 colnames(test[[i]]) = 1:3
 row.names(test[[i]]) = c('g1', 'g2', 'g3', 'g4')
}

cluster = list(c(1, 2, 2, 1), c(1, 2, 3, 1), c(2, 2, 1, 1))
names(cluster) = names(test)
for(i in names(cluster)){
 names(cluster[[i]]) = c('g1', 'g2', 'g3', 'g4')
}

membersL_noweight <- getMCI(cluster, test)
idx = c(1, 2, 1)
names(idx) = names(membersL_noweight[['sd']])
selectedSD = getMaxStats(membersL_noweight[['sd']], idx)
}
\seealso{
\code{\link{getMCI}}
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}
}
