% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getMCI_inner}
\alias{getMCI_inner}
\title{Calculating MCI Score for randomly selected}
\usage{
getMCI_inner(
  members,
  countsL,
  adjust.size,
  fun = c("cor", "BioTIP"),
  PCC_gene.target = "zero",
  M = NULL
)
}
\arguments{
\item{members}{An integer that is the length of genes in the CTS (critical transition signal).}

\item{countsL}{A list of subset of dat matrix.  The list length is the number of states.
Each subset of matrix gives the genes in rows and samples in column.}

\item{adjust.size}{A boolean value indicating if MCI score should be adjust by module size (the number of transcripts
in the module) or not. Default FALSE.}

\item{fun}{A character chosen between ("cor", "BioTIP"), indicating where an adjusted
correlation matrix will be used to calculated the MCI score.}

\item{PCC_gene.target}{A character 'zero' indicating that gene-gene correlation matrix will be shrunk.
towards zero, used only for fun='BioTIP'.}

\item{M}{is the overall shrunk correlation matrix, used only for fun='BioTIP'.}
}
\value{
A vector recording one MCI score per state.
}
\description{
This function calculates random MCI score,  allowing an estimation
of correlation matrix using the Schafer-Strimmer Method for the PCC_in component in the MCI score.
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}; Xinan H Yang \email{xyang2@uchicago.edu}
}
