% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getCluster_methods}
\alias{getCluster_methods}
\title{Clustering Network Nodes}
\usage{
getCluster_methods(
  igraphL,
  method = c("rw", "hcm", "km", "pam", "natural"),
  cutoff = NULL
)
}
\arguments{
\item{igraphL}{A list of numerical matrices or a list of igraph objects. The
list of igraph objects can be the output from the getNetwork function.}

\item{method}{A mathematical clustering model for analyzing network nodes.
Default is a random walk ('rw'). A method could be 'rw',  'hcm',  'km',
'pam',  or 'natural',  where:
\itemize{
\item rw: random walk using cluster_walktrap function in igraph package.
'igraphL' has to be a list of igraph.
\item hcm: hierarchical clustering using function \link[stats]{hclust})
and \link[stats]{dist},  using method
'complete'.
\item km and pam: k-medoids or PAM algorithm using \link[TSdist]{KMedoids}.
\item natrual: if nodes are disconnected,  they may naturally cluster and form
sub-networks.
}}

\item{cutoff}{A numeric value,  default is NULL. For each method it means:
\itemize{
\item rw: the number of steps needed, see \link[igraph]{cluster_walktrap}
for more detail. If "cutoff" is not assigned,  default of 4 will be used.
\item hcm,  km and pam: number of clusters wanted. No default assigned.
\item natural: does not use this parameter.
}}
}
\value{
When method=rw: A list of \code{\link[igraph]{communities}} objects of R package
igraph, whose length is the length of the input object \code{igraphL}.
These \code{\link[igraph]{communities}} objects can be used for
visualization when being assigned to the 'mark.groups' parameter of the
\code{\link[igraph]{plot.igraph}} function of the igraph package. Otherwise this
function returns a list of vectors, whose length is the length of the input
object \code{igraphL}. The names of each vector are the pre-selected
transcript IDs by th function \code{\link{sd_selection}}. Each vector,
whose length is the number of pre-selected transcript in a state,  contains
the module IDs.
}
\description{
This function runs over all states which are grouped samples.
For each state,  this function splits the correlation network generated from
the function \code{\link{getNetwork}} into several sub-networks (which we
called 'module'). The network nodes will be defined by the end-user. For
transcriptome analysis,  network nodes can be the expressed transcripts. The
outputs of this function include the module IDs and node IDs per module.
}
\examples{
test = list('state1' = matrix(sample(1:10, 6), 3, 3), 'state2' =
matrix(sample(1:10, 6), 3, 3), 'state3' = matrix(sample(1:10, 6), 3, 3))
#assign colnames and rownames to the matrix

for(i in names(test)){
colnames(test[[i]]) = 1:3
row.names(test[[i]]) = 1:3}

#using 'rw' or 'natural' method
igraphL <- getNetwork(test,  fdr=1)
#[1] "state1:3 nodes"
#[1] "state2:3 nodes"
#[1] "state3:3 nodes"

cl <- getCluster_methods(igraphL)

#using 'km',  'pam' or 'hcm'
cl <- getCluster_methods(test,  method = 'pam',  cutoff=2)

}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}
}
