% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSignedGmt.R
\name{readSignedGmt}
\alias{readSignedGmt}
\title{Read signed GMT files}
\usage{
readSignedGmt(
  filename,
  posPattern = "_UP$",
  negPattern = "_DN$",
  nomatch = c("ignore", "pos", "neg"),
  uniqGenes = TRUE,
  namespace = NULL
)
}
\arguments{
\item{filename}{A gmt file}

\item{posPattern}{Pattern of positive gene sets}

\item{negPattern}{Pattern of negative gene sets}

\item{nomatch}{options to deal with gene sets that match to neither posPattern nor negPattern patterns}

\item{uniqGenes}{Logical, whether genes should be made unique}

\item{namespace}{Character string or \code{NULL}, namespace of gene-sets}
}
\description{
Read signed GMT files
}
\examples{
testGmtFile <- system.file("extdata/test.gmt", package="BioQC")
testSignedGenesets.ignore <- readSignedGmt(testGmtFile, nomatch="ignore")
testSignedGenesets.pos <- readSignedGmt(testGmtFile, nomatch="pos")
testSignedGenesets.neg <- readSignedGmt(testGmtFile, nomatch="neg")
}
\seealso{
\code{\link{gmtlist2signedGenesets}} for parameters \code{posPattern}, \code{negPattern}, and \code{nomatch}
}
