% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{SignedGenesets}
\alias{SignedGenesets}
\title{Convert a list to a SignedGenesets object}
\usage{
SignedGenesets(list)
}
\arguments{
\item{list}{A list of genesets; each geneset is a list of at least three fields: 'name', 'pos', and 'neg'. 'name' contains one non-null character string, and both 'pos' and 'neg' can be either NULL or a character vector.}
}
\description{
Convert a list to a SignedGenesets object
}
\examples{
testList <- list(list(name="GS_A", pos=NULL, neg=LETTERS[1:3]),
                 list(name="GS_B", pos=LETTERS[1:5], neg=LETTERS[7:9]),
                 list(name="GS_C", pos=LETTERS[1:5], neg=NULL),
                 list(name="GS_D", pos=NULL, neg=NULL))
testSigndGS <- SignedGenesets(testList)

}
\seealso{
\code{GmtList}
}
