% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{IndexList}
\alias{IndexList}
\alias{IndexList,numeric-method}
\alias{IndexList,logical-method}
\alias{IndexList,list-method}
\title{Convert a list to an IndexList object}
\usage{
IndexList(object, ..., keepNA = FALSE, keepDup = FALSE, offset = 1L)

\S4method{IndexList}{numeric}(object, ..., keepNA = FALSE, keepDup = FALSE, offset = 1L)

\S4method{IndexList}{logical}(object, ..., keepNA = FALSE, keepDup = FALSE, offset = 1L)

\S4method{IndexList}{list}(object, keepNA = FALSE, keepDup = FALSE, offset = 1L)
}
\arguments{
\item{object}{Either a list of unique integer indices, NULL and logical 
vectors (of same lengths), or a numerical vector or a logical vector. NA is discarded.}

\item{...}{If \code{object} isn't a list, additional vectors can go here.}

\item{keepNA}{Logical, whether NA indices should be kept or not. Default: FALSE (removed)}

\item{keepDup}{Logical, whether duplicated indices should be kept or not. Default: FALSE (removed)}

\item{offset}{Integer, the starting index. Default: 1 (as in the convention of R)}
}
\value{
The function returns a list of vectors
}
\description{
Convert a list to an IndexList object
}
\examples{
testList <- list(GS_A=c(1,2,3,4,3),
                 GS_B=c(2,3,4,5),
                 GS_C=NULL,
                 GS_D=c(1,3,5,NA),
                 GS_E=c(2,4))
testIndexList <- IndexList(testList)
IndexList(c(FALSE, TRUE, TRUE), c(FALSE, FALSE, TRUE), c(TRUE, FALSE, FALSE), offset=0)
IndexList(list(A=1:3, B=4:5, C=7:9))
IndexList(list(A=1:3, B=4:5, C=7:9), offset=0)
}
