% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseasePairs.R
\name{runPermDisease}
\alias{runPermDisease}
\title{Calculate disease-disease pair overlaps on permuted network to estimate
its statistical significance}
\usage{
runPermDisease(
  gg,
  name,
  diseases = NULL,
  Nperm = 100,
  permute = c("random", "binned"),
  alpha = c(0.05, 0.01, 0.001)
)
}
\arguments{
\item{gg}{interactome network as igraph object}

\item{name}{name of the attribute that stores disease annotation}

\item{diseases}{list of diseases to match}

\item{Nperm}{number of permutations to apply}

\item{permute}{type of permutations.
\code{random} -- annotation is randomly shuffled,
\code{binned} -- annotation is shuffled in a way to preserve node
degree-annotation relationship by \code{\link{degreeBinnedGDAs}}.}

\item{alpha}{statistical significance levels}
}
\value{
list of two matrices: \code{Disease_overlap_sig} gives s
tatistics for each pair of disease, and
\code{Disease_location_sig} gives intra-disease statistics
}
\description{
Function to calculate the disease-pair overlap characteristics of an inputted
network, before applying \code{Nperm} permutations on the disease annotations
of #' type "random" or "binned" \code{permute}. From the permuted networks
the function estimates the significance of disease overlap: p-value,
Bonferoni-adjusted p-value, and q-value in the \code{Disease_overlap_sig}.
The function also compares the average disease separation between inputted
and permuted networks, and calculates its significance using the Wilcox test
and store. Significance of disease-pair overlap and disease separation
results are stored in the matrix \code{Disease_location_sig}.
}
\details{
Run with care, as large number of permutations could require a lot of
memory and be timeconsuming.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
gg <- igraph::read_graph(file, format="gml")
agg<-annotateGeneNames(gg)
# due to error in org.Hs.eg.db we have to manually check annotation of one node
idx <- which(V(agg)$name == '80273')
paste(V(agg)$GeneName[idx], 'GRPEL1')
r <- runPermDisease(
agg,
name = "TopOntoOVGHDOID",
diseases = c("DOID:10652", "DOID:3312", "DOID:12849", "DOID:1826"),
Nperm = 10,
alpha = c(0.05, 0.01, 0.001))
r$Disease_location_sig
}
