% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perturbationEntropy.R
\name{getEntropy}
\alias{getEntropy}
\title{Calculates vertex perturbation graph entropy.}
\usage{
getEntropy(gg, maxSr = NULL, exVal = NULL)
}
\arguments{
\item{gg}{igraph object}

\item{maxSr}{the maximum entropy rate \eqn{maxSR}, if NULL
\code{getEntropyRate} will be called.}

\item{exVal}{expression values boundaries.
Two columns are expected: \code{xx} and \code{lambda}.
If NULL default values \code{c(2,14)} and \code{c(-14,14)} will
be used for \code{xx} and \code{lambda} respectively.}
}
\value{
matrix containing for each Gene:
\itemize{
\item Entrez ID,
\item Name,
\item Degree,
\item UP -- Graph Entropy values when gene is expressed up,
\item DOWN -- Graph Entropy values when gene is expressed down.
}
}
\description{
According to Teschendorf et al., 2010, network entropy measure quantifies
the degree of randomness in the local pattern information flux around single
genes. For instance, in metastatic cancer this measure was found
significantly higher than in non-metastatic and helped to identify genes
and entire pathways involved on metastasis. However, for the assessment of
scale-free structure we do not actually require gene expression data as it
based solely on the network topology.
}
\details{
In this function, following procedure described in
(Teschendorff et al., 2015), all vertexes are artificially assigned a
uniform weight then sequentially perturbed with the global entropy rate
(SR) after each protein’s perturbation being calculated and plotted
against the log of the protein’s degree. In case of scale-free or
approximate scale-free topologies, we see a clear bi-modal response
between over-weighted vertices and their degree and an opposing bi-phasic
response in under-weighted vertices and their degrees.
}
\note{
Entropy is calculated with respect to GeneName property, if there is no such
vertex attribute in the graph vertex name will be copied to the GeneName
attribute. If any NA is found in GeneNames error will be thrown.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.csv", package = "BioNAR")
tbl <- read.csv(file, sep="\t")
gg <- buildNetwork(tbl)
gg<-annotateGeneNames(gg)
any(is.na(V(gg)$GeneName))
# due to error in org.Hs.eg.db we have to manually check annotation of one node
idx <- which(V(gg)$name == '80273')
paste(V(gg)$GeneName[idx], 'GRPEL1')
e<- getEntropy(gg)
}
\seealso{
Other Entropy Functions: 
\code{\link{calcEntropy}()},
\code{\link{getEntropyRate}()},
\code{\link{plotEntropy}()}
}
\concept{Entropy Functions}
