% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{calcAllClustering}
\alias{calcAllClustering}
\title{Calculate memberships for all clustering algorithms and store them on the
graph vertices.}
\usage{
calcAllClustering(gg, weights = NULL)
}
\arguments{
\item{gg}{graph for analysis}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, NULL or NA. If it is NULL and the input graph has a ‘weight’
edge attribute, then that attribute will be used. If NULL and no such
attribute is present, then the edges will have equal weights. Set
this to NA if the graph was a ‘weight’ edge attribute, but you don't
want to use it for community detection. A larger edge weight means a
stronger connection for this function. The weights value is ignored
for the \code{spectral} clustering.}
}
\value{
new graph object with all membership results stored as a vertex
attribute.
}
\description{
This function will call \code{\link{calcClustering}} for each clustering
algorithm given in our predefined list. In the event no clustering could be
performed, warnings will be issued and no new vertex attribute added to the
graph.
}
\examples{
g1 <- make_star(10, mode="undirected")
V(g1)$name <- letters[1:10]
g1<-calcAllClustering(g1)
clusteringSummary(g1)
}
\seealso{
calcClustering
}
