% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateNetwork.R
\name{annotateVertex}
\alias{annotateVertex}
\title{Generic annotation function}
\usage{
annotateVertex(gg, name, values, idatt = "name")
}
\arguments{
\item{gg}{igraph object to annotate}

\item{name}{name of the attribute}

\item{values}{annotation data.frame}

\item{idatt}{optional name of the vertex attribute to map to the
annotation \code{data.frame} first column}
}
\value{
igraph object where vertex attribute \code{name} contains
annotation terms separated by semicolon.
}
\description{
Function to build and fill a vertex attribute given an igraph object. Where
parameter 'name' is the new vertex attribute name and values are filled from
a two column data.frame supplied to 'value' attribute. The first
containing vertex name IDs, and the second the vertex annotation value.
}
\details{
As a first step all attributes with provided names will be removed.
}
\examples{
g1 <- make_star(10, mode="undirected")
V(g1)$name <- letters[1:10]
m<-rbind(data.frame(ID=letters[1:10], terms=letters[1:10]),
data.frame(ID=letters[1:10], terms=LETTERS[1:10]))
g2<-annotateVertex(g1, name='cap', values=m)
V(g2)$cap
}
\seealso{
getAnnotationVertexList
}
