% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{replacement_cpp}
\alias{replacement_cpp}
\title{Function to replace non-selected individuals in the population}
\usage{
replacement_cpp(population, offspring, num_to_replace)
}
\arguments{
\item{population}{Numeric matrix representing the population of
individuals.}

\item{offspring}{Numeric matrix representing the offspring.}

\item{num_to_replace}{Number of individuals to replace.}
}
\value{
Numeric matrix representing the updated population.
}
\description{
Replace non-selected individuals in the population
}
\examples{
# example of usage
genomic_data <- matrix(rnorm(100), nrow = 10, ncol = 10)
population <- BioGA::initialize_population_cpp(genomic_data,
                population_size = 5)
fitness <- BioGA::evaluate_fitness_cpp(genomic_data, population)
selected_parents <- BioGA::selection_cpp(population, fitness,
                      num_parents = 2)
offspring <- BioGA::crossover_cpp(selected_parents, offspring_size = 2)
mutated_offspring <- BioGA::mutation_cpp(offspring, mutation_rate = 0)
BioGA::replacement_cpp(population, mutated_offspring, num_to_replace = 1)
}
