% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocarta.R
\name{mark_gene}
\alias{mark_gene}
\title{Mark a gene on the pathway image}
\usage{
mark_gene(grob, entrez_id, fun, min_area = 0, capture = FALSE)
}
\arguments{
\item{grob}{A \code{grob} returned by \code{\link[=biocartaGrob]{biocartaGrob()}}.}

\item{entrez_id}{A single Entrez ID.}

\item{fun}{A self-defined function to add graphics to the selected gene.}

\item{min_area}{Multiple polygons may be used for one single gene in the image. It can be used
to select the largest polygon. The unit for calculating the area is the pixel in the image (or more properly, square pixels).}

\item{capture}{It is suggested to let \code{fun()} directly return \code{grob}/\code{gTree} objects. But you can also directly
use functions such as \code{grid.points()} or \code{grid.lines()} in \verb{fun(()}. In this case, \code{capture} must be set
to \code{TRUE} to capture these graphics.}
}
\value{
If \code{capture = FALSE}, it must return a grob where new graphics are already added.
}
\description{
Mark a gene on the pathway image
}
\details{
\code{fun()} should be applied to each gene. It is possible an Entrez gene is mapped to multiple nodes
in the image, so more precisely, \code{fun()} is applied to every node that contains the input gene.

\code{fun()} only accepts two arguments, \code{x} and \code{y} which are two vectors of xy-coordinates that define
the polygon. The helper function \code{\link[=pos_by_polygon]{pos_by_polygon()}} can be used to get positions around the polygon.

There are two ways to use \code{fun()}. First, \code{fun()} directly returns a \code{grob}. It can be a simple grob, such
as by \code{\link[grid:grid.points]{grid::pointsGrob()}} or complex grob by \code{\link[grid:grid.grob]{grid::gTree()}} and \code{\link[grid:grid.grob]{grid::gList()}}. Second, \code{fun()}
can directly include plotting functions such as \code{\link[grid:grid.points]{grid::grid.points()}}, in this case, \code{capture} argument
must be set to \code{TRUE} to capture these graphics.
}
\examples{
library(grid)
grid.newpage()
grob = biocartaGrob("h_RELAPathway")
# gene 1387 is a gene in the pathway
grob2 = mark_gene(grob, "1387", function(x, y) {
	pos = pos_by_polygon(x, y)
	pointsGrob(pos[1], pos[2], default.units = "native", pch = 16, 
		gp = gpar(col = "yellow"))
})
grid.draw(grob2)

grid.newpage()
grob3 = mark_gene(grob, "1387", function(x, y) {
	pos = pos_by_polygon(x, y)
	grid.points(pos[1], pos[2], default.units = "native", pch = 16,
		gp = gpar(col = "yellow"))
}, capture = TRUE)
grid.draw(grob3)

grid.newpage()
grob4 = mark_gene(grob, "1387", function(x, y) {
	pos = pos_by_polygon(x, y)
	pushViewport(viewport(x = pos[1] - 10, y = pos[2], 
		width = unit(4, "cm"), height = unit(4, "cm"), 
		default.units = "native", just = "right"))
	grid.rect(gp = gpar(fill = "red"))
	popViewport()
}, capture = TRUE)
grid.draw(grob4)
}
