% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocarta.R
\name{get_pathway_image}
\alias{get_pathway_image}
\alias{image_dimension}
\title{Download the pathway image}
\usage{
get_pathway_image(pathway)

image_dimension(pathway)
}
\arguments{
\item{pathway}{A BioCarta pathway ID, a MSigDB ID or a \code{biocarta_pathway} object. All valid BioCarta pathway IDs are in \code{\link[=all_pathways]{all_pathways()}}.
The list of MSigDB IDs for BioCarta pathways can be found at \url{https://www.gsea-msigdb.org/gsea/msigdb/human/genesets.jsp?collection=CP:BIOCARTA}.}
}
\value{
\code{get_pathway_image()} returns a \code{raster} object. \code{image_dimension()} returns an integer vector of the height and width of the image.
}
\description{
Download the pathway image
}
\details{
The images are downloaded from \url{https://data.broadinstitute.org/gsea-msigdb/msigdb/biocarta/human/}.
}
\examples{
img = get_pathway_image("h_RELAPathway")
class(img)
# you can directly plot the raster object
plot(img)

image_dimension("h_RELAPathway")
}
