% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureSelect.R
\name{featureSelect}
\alias{featureSelect}
\title{Feature selection}
\usage{
featureSelect(input, batch_effects = NULL, VGs = NULL, verbose = TRUE)
}
\arguments{
\item{input}{A \code{SpatialExperiment} object containing spatial
transcriptomics data..}

\item{batch_effects}{A character vector specifying column names in
\code{colData(input)} that indicate batch effects. Must match existing
column names.}

\item{VGs}{A character vector specifying the variable genes (VGs) to be
analyzed. Only genes present in this vector will be retained for
feature selection.}

\item{verbose}{Logical (TRUE or FALSE). Default is TRUE.
If TRUE, progress messages will be printed;
If FALSE, messages will be suppressed.}
}
\value{
A named list where each element corresponds to a batch effect.
Each batch contains a data frame with the following columns:
\itemize{
\item \strong{"gene_id"}: Gene identifier.
\item \strong{"gene_name"}: Gene name.
\item \strong{"dev_default"}: Deviance score without batch correction.
\item \strong{"dev_\if{html}{\out{<batch>}}"}: Deviance score with batch correction.
\item \strong{"rank_default"}: Rank of the gene based on deviance
without batch correction.
\item \strong{"rank_\if{html}{\out{<batch>}}"}: Rank of the gene based on deviance with
batch correction.
\item \strong{"d_diff"}: Relative change in deviance between default
and batch-corrected models.
\item \strong{"nSD_dev_\if{html}{\out{<batch>}}"}: number of standard deviation of
relative change in deviance for the batch.
\item \strong{"r_diff"}: Rank difference between default and
batch-corrected models.
\item \strong{"nSD_rank_\if{html}{\out{<batch>}}"}: number of standard deviation of
rank difference for the batch.
}
}
\description{
The function computes batch-adjusted deviance values, ranks the
genes accordingly, and quantifies batch effects in terms of standard
deviations from the mean difference. The list follows the order of batch
effects provided in \code{batch_effects}.
}
\examples{
library(spatialLIBD)
spatialLIBD_spe <- fetch_data(type = "spe")
libd_svg <- read.csv(
    system.file("extdata","libd-all_nnSVG_p-05-features-df.csv",
              package = "BatchSVG"),
    row.names = 1, check.names = FALSE)
   
list_batch_df <- featureSelect(input = spatialLIBD_spe, 
   batch_effects = "subject", VGs = libd_svg$gene_id)

}
