% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variation_ratios.R
\name{variation_ratios}
\alias{variation_ratios}
\title{Creates Ratios of batch to variable variation statistic}
\usage{
variation_ratios(ex_variation_table, batch)
}
\arguments{
\item{ex_variation_table}{table of explained variation results from
batchqc_explained_variation}

\item{batch}{batch}
}
\value{
dataframe with condition/batch ratios
}
\description{
Creates Ratios of batch to variable variation statistic
}
\examples{
library(scran)
se <- mockSCE()
se$Mutation_Status <- as.factor(se$Mutation_Status)
se$Treatment <- as.factor(se$Treatment)
expl_var_result <- batchqc_explained_variation(se, batch = "Mutation_Status",
                            condition = "Treatment", assay_name = "counts")
ratios_results <- variation_ratios(expl_var_result[[1]],
    batch = "Mutation_Status")
ratios_results
}
