% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kBET.R
\name{run_kBET}
\alias{run_kBET}
\title{kBET rejection rate}
\usage{
run_kBET(
  se,
  assay_to_normalize,
  batch,
  k0 = NULL,
  knn = NULL,
  testSize = NULL,
  do.pca = TRUE,
  dim.pca = 50,
  heuristic = TRUE,
  n_repeat = 100,
  alpha = 0.05,
  addTest = FALSE,
  verbose = FALSE,
  adapt = TRUE
)
}
\arguments{
\item{se}{SummarizedExperiment object}

\item{assay_to_normalize}{string; assay from se object to do normalization}

\item{batch}{character string of column name that represents batch}

\item{k0}{integer representing number of nearest neighbors to test on
(neighborhood size)}

\item{knn}{n x k matrix of nearest neighbors for each cell (optional)}

\item{testSize}{integer representing number of data points to test}

\item{do.pca}{Boolean, if TRUE, perform a pca prior to knn search
(defaults to TRUE)}

\item{dim.pca}{Boolean, if do.pca=TRUE, choose the number of dimensions to
consider (defaults to 50)}

\item{heuristic}{Boolean, if true, compute an optimal neighborhood size k
(defaults to TRUE)}

\item{n_repeat}{numeric representing 'n_repeat' subsets to evaluate in order
to create a statistics on batch estimates}

\item{alpha}{numeric for significance level}

\item{addTest}{Boolean, if TRUE, perform an LRT-approximation to the
multinomial test AND a multinomial exact test (if appropriate)}

\item{verbose}{Boolean, if TRUE, display stages of current computation
(defaults to FALSE)}

\item{adapt}{Boolean, if TRUE, frequencies will be adapted (defaults to TRUE)}
}
\value{
list object from kBET() function
\enumerate{
\item \code{summary} - a rejection rate for the data,
an expected rejection rate for random
labeling and the significance for the observed result
\item \code{results} - detailed list for each tested cells;
p-values for expected and observed label distribution
\item \code{average.pval} - significance level over the averaged
batch label distribution in all neighbourhoods
\item \code{stats} - extended test summary for every sample
\item \code{params} - list of input parameters and adapted parameters,
respectively
\item \code{outsider} - only shown if \code{adapt=TRUE}. List of samples
without mutual nearest neighbour: \itemize{
\item \code{index} - index of each outsider sample)
\item \code{categories} - tabularised labels of outsiders
\item \code{p.val} - Significance level of outsider batch label
distribution vs expected frequencies.
If the significance level is lower than \code{alpha},
expected frequencies will be adapted}
}
}
\description{
This function runs the k-nearest neighbor batch effect test
(kBET) to evaluate whether the data has detectable batch effect.
}
\examples{
library(scran)
se <- mockSCE()
kBET_result <- BatchQC::run_kBET(
  se=se,
  assay_to_normalize="counts",
  batch="Treatment"
)

BatchQC::plot_kBET(kBET_result)

}
