% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{pval_summary}
\alias{pval_summary}
\title{Returns summary table for p-values of explained variation}
\usage{
pval_summary(res_list)
}
\arguments{
\item{res_list}{Differential Expression analysis result (a named list of
dataframes corresponding to each analysis completed with a "pvalue" column)}
}
\value{
summary table for p-values of explained variation for each analysis
}
\description{
Returns summary table for p-values of explained variation
}
\examples{
library(scran)
se <- mockSCE()
differential_expression <- BatchQC::DE_analyze(se = se,
                                                method = "DESeq2",
                                                batch = "Treatment",
                                                conditions = c(
                                                "Mutation_Status"),
                                                assay_to_analyze = "counts",
                                                padj_method = "BH")
pval_summary(differential_expression)

}
