% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kBET.R
\name{kBET}
\alias{kBET}
\title{kBET - k-nearest neighbour batch effect test}
\usage{
kBET(
  df,
  batch,
  k0 = NULL,
  knn = NULL,
  testSize = NULL,
  do.pca = TRUE,
  dim.pca = 50,
  heuristic = TRUE,
  n_repeat = 100,
  alpha = 0.05,
  addTest = FALSE,
  verbose = FALSE,
  plot = TRUE,
  adapt = TRUE
)
}
\arguments{
\item{df}{dataset (rows: cells, columns: features)}

\item{batch}{batch id for each cell or a data frame with
both condition and replicates}

\item{k0}{number of nearest neighbours to test on (neighbourhood size)}

\item{knn}{an n x k matrix of nearest neighbours for each cell (optional)}

\item{testSize}{number of data points to test,
(10 percent sample size default, but at least 25)}

\item{do.pca}{perform a pca prior to knn search? (defaults to TRUE)}

\item{dim.pca}{if do.pca=TRUE, choose the number of dimensions
to consider (defaults to 50)}

\item{heuristic}{compute an optimal neighbourhood size k
(defaults to TRUE)}

\item{n_repeat}{to create a statistics on batch estimates,
evaluate 'n_repeat' subsets}

\item{alpha}{significance level}

\item{addTest}{perform an LRT-approximation to the multinomial
test AND a multinomial exact test (if appropriate)}

\item{verbose}{displays stages of current computation (defaults to FALSE)}

\item{plot}{if stats > 10, then a boxplot of the resulting
rejection rates is created}

\item{adapt}{In some cases, a number of cells do not contribute
to any neighbourhood
and this may cause an imbalance in observed and expected batch
label frequencies.
Frequencies will be adapted if adapt=TRUE (default).}
}
\value{
list object
\enumerate{
\item \code{summary} - a rejection rate for the data,
an expected rejection rate for random
labeling and the significance for the observed result
\item \code{results} - detailed list for each tested cells;
p-values for expected and observed label distribution
\item \code{average.pval} - significance level over the averaged
batch label distribution in all neighbourhoods
\item \code{stats} - extended test summary for every sample
\item \code{params} - list of input parameters and adapted parameters,
respectively
\item \code{outsider} - only shown if \code{adapt=TRUE}. List of samples
without mutual nearest neighbour: \itemize{
\item \code{index} - index of each outsider sample)
\item \code{categories} - tabularised labels of outsiders
\item \code{p.val} - Significance level of outsider batch label
distribution vs expected frequencies.
If the significance level is lower than \code{alpha},
expected frequencies will be adapted}
}

If the optimal neighbourhood size (k0) is smaller than 10, NA is
returned.
}
\description{
adapted from kBET package (https://github.com/theislab/kBET).
\code{kBET} runs a chi square test to evaluate
the probability of a batch effect.
}
\examples{
library(scran)
se <- mockSCE()
df <- as.matrix(assays(se)[["counts"]])
batch <- data.frame(colData(se))[, "Treatment"]

batch.estimate <- kBET(df, batch)

}
