% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explained_variation.R
\name{batchqc_explained_variation}
\alias{batchqc_explained_variation}
\title{Returns a list of explained variation by batch and condition
combinations}
\usage{
batchqc_explained_variation(se, batch, condition = NULL, assay_name)
}
\arguments{
\item{se}{Summarized experiment object}

\item{batch}{Batch covariate}

\item{condition}{Condition covariate(s) of interest if desired, default is
NULL}

\item{assay_name}{Assay of choice}
}
\value{
List of explained variation by batch and condition
}
\description{
Returns a list of explained variation by batch and condition
combinations
}
\examples{
library(scran)
se <- mockSCE()
batchqc_explained_variation <- BatchQC::batchqc_explained_variation(se,
                                        batch = "Mutation_Status",
                                        condition = "Treatment",
                                        assay_name = "counts")
batchqc_explained_variation

}
