% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{DE_analyze}
\alias{DE_analyze}
\title{Differential Expression Analysis}
\usage{
DE_analyze(se, method, batch, conditions, assay_to_analyze, padj_method)
}
\arguments{
\item{se}{SummarizedExperiment object}

\item{method}{DE analysis method option
('DESeq2', 'limma', 'edgeR', 'ANOVA', or 'Kruskal-Wallis')}

\item{batch}{metadata column in the se object representing batch}

\item{conditions}{metadata columns in the se object representing additional
analysis covariates}

\item{assay_to_analyze}{Assay in the se object (either counts for DESeq2 or
normalized data for limma or edgeR) for DE analysis}

\item{padj_method}{correction method for adjusted p-value from
p.adjust.methods}
}
\value{
A named list containing the log2FoldChange, fvalue (ANOVA only),
pvalue and adjusted pvalue (padj) for each analysis returned by DESeq2,
limma, edgeR, ANOVA, or Kruskal-Wallis.
}
\description{
This function runs DE analysis on a count matrix (DESeq), a normalized log or
log-CPM matrix (limma), an edgeR TMM-normalized matrix (edgeR) or perform
ANOVA or Kruskal-Wallis test on the data contained in the se object.
}
\examples{
library(scran)
se <- mockSCE()
differential_expression <- BatchQC::DE_analyze(se = se,
                                                method = "DESeq2",
                                                batch = "Treatment",
                                                conditions = c(
                                                "Mutation_Status"),
                                                assay_to_analyze = "counts",
                                                padj_method = "BH")
pval_summary(differential_expression)
pval_plotter(differential_expression)

}
