% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{smoothLabels}
\alias{smoothLabels}
\title{k-Nearest neighbor cluster label smoothing.}
\usage{
smoothLabels(
  se,
  cluster_names = NULL,
  coord_names = NULL,
  k = 15L,
  prop_thres = 0.5,
  max_iter = 10,
  verbose = TRUE
)
}
\arguments{
\item{se}{A \code{SpatialExperiment},
\code{SingleCellExperiment} or \code{SummarizedExperiment}
  object with cluster labels in \code{colData(se)}.}

\item{cluster_names}{A string vector of label names to smooth. If NULL,
smooths labels in colData(se) matching /^clust/}

\item{coord_names}{A string vector specifying the names in \code{colData}
corresponding to spatial coordinates.}

\item{k}{An integer scalar specifying number of neighbors for smooething.}

\item{prop_thres}{A numeric scalar \eqn{\in [0,1]} specifying a label
proportions threshold If the fraction of neighbors with a certain label
exceeds this proportion, change the label of the current sample
(default: 0.5).}

\item{max_iter}{An integer scalar specifying the max number of smoothing
iterations. Set to -1 for smoothing to convergence.}

\item{verbose}{A logical scalar specifying verbosity.}
}
\value{
A SpatialExperiment / SingleCellExperiment / SummarizedExperiment
  object with smoothed cluster labels in \code{colData(se)} suffixed with
  '_smooth'.
}
\description{
k-Nearest neighbor cluster label smoothing.
}
\details{
As described in SpiceMix (https://doi.org/10.1038/s41588-022-01256-z). 
Implemented for labels that can be coerced to numeric only.
}
\examples{
data(rings)
spe <- computeBanksy(rings, assay_name = "counts", M = 1, k_geom = c(15, 30))
spe <- runBanksyPCA(spe, M = 1, lambda = 0.2, npcs = 20)
spe <- clusterBanksy(spe, M = 1, lambda = 0.2, resolution = 1)
spe <- smoothLabels(spe, cluster_names = "clust_M1_lam0.2_k50_res1")

}
