% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduction.R
\name{runBanksyPCA}
\alias{runBanksyPCA}
\title{Run PCA on a BANKSY matrix.}
\usage{
runBanksyPCA(
  se,
  use_agf = FALSE,
  lambda = 0.2,
  npcs = 20L,
  assay_name = NULL,
  scale = TRUE,
  group = NULL,
  M = NULL,
  seed = NULL
)
}
\arguments{
\item{se}{A \code{SpatialExperiment},
\code{SingleCellExperiment} or \code{SummarizedExperiment}
  object with \code{computeBanksy} ran.}

\item{use_agf}{A logical vector specifying whether to use the AGF for
computing principal components.}

\item{lambda}{A numeric vector in \eqn{\in [0,1]} specifying a spatial
weighting parameter. Larger values (e.g. 0.8) incorporate more spatial
neighborhood and find spatial domains, while smaller values (e.g. 0.2)
perform spatial cell-typing.}

\item{npcs}{An integer scalar specifying the number of principal components
to compute.}

\item{assay_name}{A string scalar specifying the name of the assay used in
\code{computeBanksy}.}

\item{scale}{A logical scalar specifying whether to scale features before
PCA. Defaults to TRUE.}

\item{group}{A string scalar specifying a grouping variable for samples in
\code{se}. This is used to scale the samples in each group separately.}

\item{M}{Advanced usage. An integer vector specifying the highest azimuthal
Fourier harmonic to use. If specified, overwrites the \code{use_agf}
argument.}

\item{seed}{Seed for PCA. If not specified, no seed is set.}
}
\value{
A SpatialExperiment / SingleCellExperiment / SummarizedExperiment
  object with PC coordinates in \code{reducedDims(se)}.
}
\description{
Run PCA on a BANKSY matrix.
}
\details{
This function runs PCA on the BANKSY matrix 
(see \link[Banksy]{getBanksyMatrix}) with features scaled to zero mean and 
unit standard deviation.
}
\examples{
data(rings)
spe <- computeBanksy(rings, assay_name = "counts", M = 1, k_geom = c(15, 30))
spe <- runBanksyPCA(spe, M = 1, lambda = 0.2, npcs = 20)

}
