% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaalChIP-generics.R, R/BaalChIP-methods.R
\name{filterIntbias}
\alias{filterIntbias}
\alias{filterIntbias,BaalChIP-method}
\title{Method filterIntbias}
\usage{
filterIntbias(
  .Object,
  simul_output = NULL,
  tmpfile_prefix = NULL,
  simulation_script = "local",
  alignmentSimulArgs = NULL,
  skipScriptRun = FALSE,
  verbose = TRUE
)

\S4method{filterIntbias}{BaalChIP}(
  .Object,
  simul_output = NULL,
  tmpfile_prefix = NULL,
  simulation_script = "local",
  alignmentSimulArgs = NULL,
  skipScriptRun = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{.Object}{An object of the \code{\link{BaalChIP}} class.}

\item{simul_output}{a non-empty character vector giving the directory of where to save the FASTQ and BAM files generated by the function. If NULL, a random directory under the current working directory will be generated.}

\item{tmpfile_prefix}{an optional character vector giving the initial part of the name of the FASTQ and BAM files generated by the function. If NULL, a random name will be generated.}

\item{simulation_script}{the file path for simulation script containing the instructions of simulation and alignment commands. If NULL, the default simulation script distributed with BaalChIP ('extra/simulation_run.sh') will be used.}

\item{alignmentSimulArgs}{a character vector with arguments to the simulation script. If NULL no arguments are passed.}

\item{skipScriptRun}{a logical value indicating if simulation BAM files should not be generated. If TRUE BaalChIP will look for the BAM files in the 'simul_output/temp_prefix' (default is FALSE).}

\item{verbose}{logical. If TRUE reports extra information on the process}
}
\value{
An updated \code{\link{BaalChIP}} object with the slot \code{alleleCounts} containing a list of GRanges objects that pass filters.
}
\description{
Filters the data frame available within a \code{\link{BaalChIP}} object (slot \code{alleleCounts}). This filter performs simulations of reads of the same length as the original ChIP-seq reads, aligns the simulated reads to the genome, calculates the allelic ratios for each variant and finally ignores those variants for which the allelic ratio (REF/TOTAL) is different than 0.5.
}
\examples{
samplesheet <- system.file("test", "exampleChIP.tsv", package = "BaalChIP")  
hets <- c("MCF7"= system.file("test", "MCF7_hetSNP.txt", package = "BaalChIP"), 
         "GM12891"= system.file("test", "GM12891_hetSNP.txt", package = "BaalChIP"))
res <- BaalChIP(samplesheet=samplesheet, hets=hets)
res <- alleleCounts(res, min_base_quality=10, min_mapq=15)
skipScriptRun=TRUE #For demonstration purposes only (read details in vignette)
res <- filterIntbias(res,
      simul_output=system.file('test/simuloutput',package='BaalChIP'),
      tmpfile_prefix='c67c6ec6c433', skipScriptRun=TRUE)

#check results
plotSimul(res)
summaryQC(res)
}
\seealso{
\code{\link{BaalChIP.get}}, \code{\link{plotQC}}, \code{\link{summaryQC}}
}
\author{
Ines de Santiago
}
