% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_granges.R
\name{extend_granges}
\alias{extend_granges}
\title{Extend GRanges}
\usage{
extend_granges(
  input_gr_to_extend,
  input_gr_to_overlap,
  extend_existing_exons = TRUE,
  add_new_exons = TRUE,
  overlap_resolution_fn = NULL
)
}
\arguments{
\item{input_gr_to_extend}{A GRanges to extend
(only exons are kept and strand * are excluded)}

\item{input_gr_to_overlap}{A GRanges with intervals to overlap}

\item{extend_existing_exons}{A boolean that indicates
if existing exons should be extended}

\item{add_new_exons}{A boolean that indicates
if new exons with compatible splicing event
should be added}

\item{overlap_resolution_fn}{A file path where the dataframe giving details
on the collision resolution is written}
}
\value{
A GRanges based on `input_gr_to_extend` where exons are extended
        and new exons can be added.
        Exons extended will have a '.ext' suffix to the original exon_id.
        Exons added will have a exon_id starting with 'BREW3R'.
}
\description{
A function that from a GRanges from gtf
will extend the 3' of transcripts using
another GRanges from gtf as a template
}
\details{
During the extension process a special care is taking to prevent extension
which would lead to overlap between different gene_ids.
}
\examples{
# Very simple case
# input_gr:      ------->           ----->
# to_overlap:  ------------------>

# output:        ---------------->  ----->

input_gr <- GenomicRanges::GRanges(
    seqnames = "chr1",
    ranges = IRanges::IRanges(
        start = c(5, 20),
        end = c(10, 30)
    ),
    strand = "+",
    gene_id = c("gene1", "gene2"),
    transcript_id = c("transcript1", "transcript2"),
    type = "exon",
    exon_id = c("exon1", "exon2")
)

input_gr_to_overlap <- GenomicRanges::GRanges(
    seqnames = "chr1",
    ranges = IRanges::IRanges(
        start = 3,
        end = 15
    ),
    strand = "+",
    gene_id = "geneA",
    transcript_id = "transcriptA",
    type = "exon",
    exon_id = "exonA"
)

extend_granges(input_gr, input_gr_to_overlap)

}
