% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{add_new_exons}
\alias{add_new_exons}
\title{Add new exons}
\usage{
add_new_exons(input_gr_to_extend, input_gr_with_new_exons)
}
\arguments{
\item{input_gr_to_extend}{A GRanges to be complemented}

\item{input_gr_with_new_exons}{A GRanges with exons to be added
to the first one (exons with strand '*' are excluded)}
}
\value{
A GRanges identical to `input_gr_to_extend` with new exons
        whose `exon_id` contains BREW3R. `exon_number` may have changed.
}
\description{
A function that from 2 GRanges add exons from the second one
to the first one
if the 3p of the last exon of the transcript in the first GRanges
matches the 3p of an exon in the second one
}
\details{
Potential new exons will be filtered for collision with exons present
in the first GRanges even if they belong to the same gene_id.
For the moment all potential exons extensions are added to the
same existing transcript_id so introns maybe artificial introns.
}
