% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCStan.R
\name{BASiCStan}
\alias{BASiCStan}
\title{Stan implementation of BASiCS.}
\usage{
BASiCStan(
  Data,
  Method = c("vb", "sampling", "optimizing"),
  WithSpikes = length(altExpNames(Data)) > 0,
  Regression = TRUE,
  BatchInfo = Data$BatchInfo,
  L = 12,
  PriorMu = c("EmpiricalBayes", "uninformative"),
  NormFactorFun = scran::calculateSumFactors,
  ReturnBASiCS = TRUE,
  Verbose = TRUE,
  ...
)
}
\arguments{
\item{Data}{SingleCellExperiment object}

\item{Method}{Inference method. One of: \code{"vb"} for Variational Bayes,
\code{"sampling"} for Hamiltonian Monte Carlo,
\code{"optimizing"} for or maximum \emph{a posteriori} estimation.}

\item{WithSpikes}{Do the data contain spike-in genes? See BASiCS for details.
When \code{WithSpikes=FALSE}, the cell-specific scaling normalisation
factors are fixed; use \code{NormFactorFun} to specify how size factors
should be generated or extracted.}

\item{Regression}{Use joint prior for mean and overdispersion parameters?
Included for compatibility with \code{\link[BASiCS]{BASiCS_MCMC}},
but only \code{TRUE} is supported.}

\item{BatchInfo}{Vector describing which batch each cell is from.}

\item{L}{Number of regression terms (including slope and intercept) to use in
joint prior for mu and delta.}

\item{PriorMu}{Type of prior to use for mean expression. Default is
"EmpiricalBayes", but "uninformative" is the prior used in Eling et al. and
previous work.}

\item{NormFactorFun}{Function that returns cell-specific scaling
normalisation factors. See \code{\link[scran]{computeSumFactors}} for
details on the default.}

\item{ReturnBASiCS}{Should the object be converted into a
\linkS4class{BASiCS_Chain} object?}

\item{Verbose}{Should output of the stan commands be printed to
the terminal?}

\item{...}{Passed to vb or sampling.}
}
\value{
An object of class \code{\linkS4class{BASiCS_Chain}}.
}
\description{
The stan programming language enables the use of MAP, VB, and HMC inference.
Only the regression mode featuring a joint prior between mean and
overdispersion parameters is implemented
}
\examples{
library("BASiCS")
sce <- BASiCS_MockSCE(NGenes = 10, NCells = 10)

fit_spikes <- BASiCStan(sce, tol_rel_obj = 1)

## uses fixed scaling normalisation factors
fit_nospikes <- BASiCStan(sce, WithSpikes = FALSE, tol_rel_obj = 1)

}
