% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{BASiCS_Chain}
\alias{BASiCS_Chain}
\alias{BASiCS_Chain-class}
\title{The BASiCS_Chain class}
\description{
Container of an MCMC sample of the BASiCS' model parameters
as generated by the function \code{\link[BASiCS]{BASiCS_MCMC}}.
}
\section{Slots}{

\describe{
\item{\code{parameters}}{List of matrices containing MCMC chains for each model
parameter. Depending on the mode in which BASiCS was run, the following
parameters can appear in the list:
\describe{
\item{\code{mu}}{MCMC chain for gene-specific mean expression parameters
\eqn{\mu_i}, biological genes only
(matrix with \code{q.bio} columns, all elements must be positive numbers)}
\item{delta}{MCMC chain for gene-specific biological over-dispersion
parameters \eqn{\delta_i}, biological genes only
(matrix with \code{q.bio} columns, all elements must be positive numbers)}
\item{phi}{MCMC chain for cell-specific mRNA content normalisation parameters
\eqn{\phi_j} (matrix with \code{n} columns, all elements must be positive
numbers and the sum of its elements must be equal to \code{n})}
This parameter is only used when spike-in genes are available.
\item{s}{MCMC chain for cell-specific technical normalisation parameters
\eqn{s_j} (matrix with \code{n} columns,
all elements must be positive numbers)}
\item{nu}{MCMC chain for cell-specific random effects \eqn{\nu_j}
(matrix with \code{n} columns, all elements must be positive numbers)}
\item{theta}{MCMC chain for technical over-dispersion parameter(s)
\eqn{\theta} (matrix, all elements must be positive,
each colum represents 1 batch)}
\item{\code{beta}}{Only relevant for regression BASiCS model (Eling et al,
2017). MCMC chain for regression coefficients (matrix with \code{k} columns,
where \code{k} represent the number of chosen basis functions + 2) }
\item{\code{sigma2}}{Only relevant for regression BASiCS model (Eling et al,
2017). MCMC chain for the residual variance (matrix with one column, sigma2
represents a global parameter)}
\item{\code{epsilon}}{Only relevant for regression BASiCS model (Eling et al,
2017). MCMC chain for the gene-specific residual over-dispersion parameter
(matrix with \code{q} columns)}
\item{\code{RefFreq}}{Only relevant for no-spikes BASiCS model (Eling et al,
2017). For each biological gene, this vector displays the proportion of
times for which each gene was used as a reference (within the MCMC
algorithm), when using the stochastic reference choice described in
(Eling et al, 2017). This information has been kept as it is useful for the
developers of this library. However, we do not expect users to need it. }
}}
}}

\examples{

# A BASiCS_Chain object created by the BASiCS_MCMC function.
Data <- makeExampleBASiCS_Data()

# To run the model without regression
Chain <- BASiCS_MCMC(Data, N = 100, Thin = 2, Burn = 2, Regression = FALSE)

# To run the model using the regression model
ChainReg <- BASiCS_MCMC(Data, N = 100, Thin = 2, Burn = 2, Regression = TRUE)

}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}
}
