% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoreAssessmentResults.R
\name{ScoreAssessmentResults}
\alias{ScoreAssessmentResults}
\title{Score Gene Assessment Results}
\usage{
ScoreAssessmentResults(x, mode = "a")
}
\arguments{
\item{x}{An object of class \code{Assessment} and subclass \code{Results}.}

\item{mode}{Must either be "a" (use all evidence), "p" (use proteomics evidence only), or
"c" (use evolutionary conservation evidence only)}
}
\value{
A numeric vector of length one containing the calculated accuracy-like score.
}
\description{
Scores the results from the assessment of a set of genes using one of three modes
}
\details{
\code{ScoreAssessmentResults} calculates an accuracy-like score for the categorization of genes within the given
\code{Results} object using the given mode of calculation. The score for a mode is equal to the number of genes that
were categorized to be correct for that mode divided by the total number of genes that could have been categorized as
correct for that mode (i.e. a count of the number of genes that had available and useable evidence for that particular
mode).

Open reading frames with proteomics evidence but no predicted start are included in the total gene count when calculating
the accuracy-like score for the proteomics mode and for the all evidence mode.
}
\examples{

currResObj <- readRDS(system.file("extdata",
                                  "MGAS5005_PreSaved_ResultsObj_Prodigal.rds",
                                  package = "AssessORF"))

ScoreAssessmentResults(currResObj, "a")

ScoreAssessmentResults(currResObj, "c")

ScoreAssessmentResults(currResObj, "p")

}
\seealso{
\code{\link{Assessment-class}}
}
