% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_notebook.R
\name{as_notebook}
\alias{as_notebook}
\title{Render vignettes as .ipynb notebooks}
\usage{
as_notebook(
  rmd_paths,
  namespace,
  name,
  update = FALSE,
  type = c("ipynb", "rmd", "both"),
  quarto = c("render", "convert")
)
}
\arguments{
\item{rmd_paths}{\code{character()} paths to Rmd or Qmd files.}

\item{namespace}{\code{character(1)} AnVIL namespace (billing project)
to be used.}

\item{name}{\code{character(1)} AnVIL workspace name.}

\item{update}{\code{logical(1)} Update (over-write any similarly named
notebooks) an existing workspace? The default (FALSE) creates
notebooks locally, e.g., for previewing via \verb{jupyter notebook *ipynb}.}

\item{type}{\code{character(1)} The type of notebook to be copied to the
workspace. Must be on of \code{ipynb}, \code{rmd}, or \code{both}. \code{ipynb}
copies only the Jupyter notebook. \code{rmd} copies Rmarkdown and
Quarto vignettes. \code{both} copies both notebooks and vignettes.}

\item{quarto}{\code{character(1)} If the program Quarto is installed,
this parameter indicates whether the .Rmd files will be
rendered or converted.  See vignette for more details.}
}
\value{
\code{as_notebook()} returns the paths to the local (if \code{update = FALSE}) or the workspace notebooks.
}
\description{
\code{as_notebook()} renders Rmarkdown (\code{.Rmd}) or Quarto
(\code{.Qmd}) vignettes as Juptyer (\code{.ipynb}) notebooks. The
vignettes and notebooks are updated in an AnVIL workspace.
}
\details{
See the vignette
"Publishing R / Bioconductor Packages To AnVIL Workspaces" for
details on the conversion process; best results are obtained
when Quarto software is available.
}
