% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_helpers.R
\name{nmr_pca_build_model}
\alias{nmr_pca_build_model}
\alias{nmr_pca_build_model.nmr_dataset_1D}
\title{Build a PCA on for an nmr_dataset}
\usage{
nmr_pca_build_model(
  nmr_dataset,
  ncomp = NULL,
  center = TRUE,
  scale = FALSE,
  ...
)

\method{nmr_pca_build_model}{nmr_dataset_1D}(
  nmr_dataset,
  ncomp = NULL,
  center = TRUE,
  scale = FALSE,
  ...
)
}
\arguments{
\item{nmr_dataset}{a \link{nmr_dataset_1D} object}

\item{ncomp}{Integer, if data is complete \code{ncomp} decides the number of
components and associated eigenvalues to display from the \code{pcasvd}
algorithm and if the data has missing values, \code{ncomp} gives the number
of components to keep to perform the reconstitution of the data using the
NIPALS algorithm. If \code{NULL}, function sets \code{ncomp = min(nrow(X),
ncol(X))}}

\item{center}{(Default=TRUE) Logical, whether the variables should be shifted
to be zero centered. Only set to FALSE if data have already been centered.
Alternatively, a vector of length equal the number of columns of \code{X}
can be supplied. The value is passed to \code{\link{scale}}. If the data
contain missing values, columns should be centered for reliable results.}

\item{scale}{(Default=FALSE) Logical indicating whether the variables should be
scaled to have unit variance before the analysis takes place. The default is
\code{FALSE} for consistency with \code{prcomp} function, but in general
scaling is advisable. Alternatively, a vector of length equal the number of
columns of \code{X} can be supplied. The value is passed to
\code{\link{scale}}.}

\item{...}{Additional arguments passed on to \link[mixOmics:pca]{mixOmics::pca}}
}
\value{
A PCA model as given by \link[mixOmics:pca]{mixOmics::pca} with two additional attributes:
\itemize{
\item \code{nmr_data_axis} containing the full ppm axis
\item \code{nmr_included} with the data points included in the model
These attributes are used internally by AlpsNMR to create loading plots
}
}
\description{
This function builds a PCA model with all the NMR spectra. Regions with
zero values (excluded regions) or near-zero variance regions are automatically
excluded from the analysis.
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
model <- nmr_pca_build_model(dataset_1D)

dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
model <- nmr_pca_build_model(dataset_1D)

}
\seealso{
Other PCA related functions: 
\code{\link{nmr_pca_outliers}()},
\code{\link{nmr_pca_outliers_filter}()},
\code{\link{nmr_pca_outliers_plot}()},
\code{\link{nmr_pca_outliers_robust}()},
\code{\link{nmr_pca_plots}}
}
\concept{PCA related functions}
