% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_meta.R
\name{nmr_meta_get}
\alias{nmr_meta_get}
\title{Get metadata}
\usage{
nmr_meta_get(samples, columns = NULL, groups = NULL)
}
\arguments{
\item{samples}{a \link{nmr_dataset_family} object}

\item{columns}{Columns to get. By default gets all the columns.}

\item{groups}{Groups to get. Groups are predefined of columns. Typically
\code{"external"} for metadata added with \link{nmr_meta_add}.

Both \code{groups} and \code{columns} can't be given simultaneously.}
}
\value{
a data frame with the injection metadata
}
\description{
Get metadata
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
metadata <- nmr_meta_get(dataset)

}
\seealso{
Other metadata functions: 
\code{\link{Pipelines}},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_meta_groups}()}

Other nmr_dataset functions: 
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get_column}()}

Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}

Other nmr_dataset_peak_table functions: 
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get_column}()}
}
\concept{metadata functions}
\concept{nmr_dataset functions}
\concept{nmr_dataset_1D functions}
\concept{nmr_dataset_peak_table functions}
